// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkFunction.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct CollectorProvisioningState : IEquatable<CollectorProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CollectorProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CollectorProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static CollectorProvisioningState Succeeded { get; } = new CollectorProvisioningState(SucceededValue);
        /// <summary> Updating. </summary>
        public static CollectorProvisioningState Updating { get; } = new CollectorProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static CollectorProvisioningState Deleting { get; } = new CollectorProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static CollectorProvisioningState Failed { get; } = new CollectorProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="CollectorProvisioningState"/> values are the same. </summary>
        public static bool operator ==(CollectorProvisioningState left, CollectorProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CollectorProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(CollectorProvisioningState left, CollectorProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CollectorProvisioningState"/>. </summary>
        public static implicit operator CollectorProvisioningState(string value) => new CollectorProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CollectorProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CollectorProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
