// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkFunction
{
    internal class AzureTrafficCollectorOperationSource : IOperationSource<AzureTrafficCollectorResource>
    {
        private readonly ArmClient _client;

        internal AzureTrafficCollectorOperationSource(ArmClient client)
        {
            _client = client;
        }

        AzureTrafficCollectorResource IOperationSource<AzureTrafficCollectorResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AzureTrafficCollectorData.DeserializeAzureTrafficCollectorData(document.RootElement);
            return new AzureTrafficCollectorResource(_client, data);
        }

        async ValueTask<AzureTrafficCollectorResource> IOperationSource<AzureTrafficCollectorResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AzureTrafficCollectorData.DeserializeAzureTrafficCollectorData(document.RootElement);
            return new AzureTrafficCollectorResource(_client, data);
        }
    }
}
