// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.NetworkFunction.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableNetworkFunctionResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableNetworkFunctionResourceGroupResource"/> class for mocking. </summary>
        protected MockableNetworkFunctionResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableNetworkFunctionResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableNetworkFunctionResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of AzureTrafficCollectorResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of AzureTrafficCollectorResources and their operations over a AzureTrafficCollectorResource. </returns>
        public virtual AzureTrafficCollectorCollection GetAzureTrafficCollectors()
        {
            return GetCachedClient(client => new AzureTrafficCollectorCollection(client, Id));
        }

        /// <summary>
        /// Gets the specified Azure Traffic Collector in a specified resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkFunction/azureTrafficCollectors/{azureTrafficCollectorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureTrafficCollectors_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AzureTrafficCollectorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureTrafficCollectorName"> Azure Traffic Collector name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="azureTrafficCollectorName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="azureTrafficCollectorName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AzureTrafficCollectorResource>> GetAzureTrafficCollectorAsync(string azureTrafficCollectorName, CancellationToken cancellationToken = default)
        {
            return await GetAzureTrafficCollectors().GetAsync(azureTrafficCollectorName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets the specified Azure Traffic Collector in a specified resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkFunction/azureTrafficCollectors/{azureTrafficCollectorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureTrafficCollectors_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AzureTrafficCollectorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureTrafficCollectorName"> Azure Traffic Collector name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="azureTrafficCollectorName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="azureTrafficCollectorName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AzureTrafficCollectorResource> GetAzureTrafficCollector(string azureTrafficCollectorName, CancellationToken cancellationToken = default)
        {
            return GetAzureTrafficCollectors().Get(azureTrafficCollectorName, cancellationToken);
        }
    }
}
