// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.NetworkFunction.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.NetworkFunction
{
    /// <summary>
    /// A class representing the AzureTrafficCollector data model.
    /// Azure Traffic Collector resource.
    /// </summary>
    public partial class AzureTrafficCollectorData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AzureTrafficCollectorData"/>. </summary>
        /// <param name="location"> The location. </param>
        public AzureTrafficCollectorData(AzureLocation location) : base(location)
        {
            CollectorPolicies = new ChangeTrackingList<SubResource>();
        }

        /// <summary> Initializes a new instance of <see cref="AzureTrafficCollectorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="collectorPolicies"> Collector Policies for Azure Traffic Collector. </param>
        /// <param name="virtualHub"> The virtualHub to which the Azure Traffic Collector belongs. </param>
        /// <param name="provisioningState"> The provisioning state of the application rule collection resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AzureTrafficCollectorData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ETag? etag, IReadOnlyList<SubResource> collectorPolicies, SubResource virtualHub, CollectorProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ETag = etag;
            CollectorPolicies = collectorPolicies;
            VirtualHub = virtualHub;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AzureTrafficCollectorData"/> for deserialization. </summary>
        internal AzureTrafficCollectorData()
        {
        }

        /// <summary> A unique read-only string that changes whenever the resource is updated. </summary>
        public ETag? ETag { get; }
        /// <summary> Collector Policies for Azure Traffic Collector. </summary>
        public IReadOnlyList<SubResource> CollectorPolicies { get; }
        /// <summary> The virtualHub to which the Azure Traffic Collector belongs. </summary>
        internal SubResource VirtualHub { get; set; }
        /// <summary> Gets Id. </summary>
        public ResourceIdentifier VirtualHubId
        {
            get => VirtualHub is null ? default : VirtualHub.Id;
        }

        /// <summary> The provisioning state of the application rule collection resource. </summary>
        public CollectorProvisioningState? ProvisioningState { get; }
    }
}
