// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.NetworkFunction.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmNetworkFunctionModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="NetworkFunction.AzureTrafficCollectorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="collectorPolicies"> Collector Policies for Azure Traffic Collector. </param>
        /// <param name="virtualHubId"> The virtualHub to which the Azure Traffic Collector belongs. </param>
        /// <param name="provisioningState"> The provisioning state of the application rule collection resource. </param>
        /// <returns> A new <see cref="NetworkFunction.AzureTrafficCollectorData"/> instance for mocking. </returns>
        public static AzureTrafficCollectorData AzureTrafficCollectorData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ETag? etag = null, IEnumerable<SubResource> collectorPolicies = null, ResourceIdentifier virtualHubId = null, CollectorProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            collectorPolicies ??= new List<SubResource>();

            return new AzureTrafficCollectorData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                etag,
                collectorPolicies?.ToList(),
                virtualHubId != null ? ResourceManagerModelFactory.SubResource(virtualHubId) : null,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="NetworkFunction.CollectorPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> A unique read-only string that changes whenever the resource is updated. </param>
        /// <param name="ingestionPolicy"> Ingestion policies. </param>
        /// <param name="emissionPolicies"> Emission policies. </param>
        /// <param name="provisioningState"> The provisioning state. </param>
        /// <returns> A new <see cref="NetworkFunction.CollectorPolicyData"/> instance for mocking. </returns>
        public static CollectorPolicyData CollectorPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ETag? etag = null, IngestionPolicyPropertiesFormat ingestionPolicy = null, IEnumerable<EmissionPoliciesPropertiesFormat> emissionPolicies = null, CollectorProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            emissionPolicies ??= new List<EmissionPoliciesPropertiesFormat>();

            return new CollectorPolicyData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                etag,
                ingestionPolicy,
                emissionPolicies?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }
    }
}
