// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.NetworkCloud.Models;

namespace Azure.ResourceManager.NetworkCloud
{
    /// <summary>
    /// A class representing the NetworkCloudVirtualMachineConsole data model.
    /// Console represents the console of an on-premises Network Cloud virtual machine.
    /// </summary>
    public partial class NetworkCloudVirtualMachineConsoleData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkCloudVirtualMachineConsoleData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location of the cluster manager associated with the cluster this virtual machine is created on. </param>
        /// <param name="enabled"> The indicator of whether the console access is enabled. </param>
        /// <param name="sshPublicKey"> The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedLocation"/> or <paramref name="sshPublicKey"/> is null. </exception>
        public NetworkCloudVirtualMachineConsoleData(AzureLocation location, ExtendedLocation extendedLocation, ConsoleEnabled enabled, NetworkCloudSshPublicKey sshPublicKey) : base(location)
        {
            Argument.AssertNotNull(extendedLocation, nameof(extendedLocation));
            Argument.AssertNotNull(sshPublicKey, nameof(sshPublicKey));

            ExtendedLocation = extendedLocation;
            Enabled = enabled;
            SshPublicKey = sshPublicKey;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudVirtualMachineConsoleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location of the cluster manager associated with the cluster this virtual machine is created on. </param>
        /// <param name="detailedStatus"> The more detailed status of the console. </param>
        /// <param name="detailedStatusMessage"> The descriptive message about the current detailed status. </param>
        /// <param name="enabled"> The indicator of whether the console access is enabled. </param>
        /// <param name="expireOn"> The date and time after which the key will be disallowed access. </param>
        /// <param name="privateLinkServiceId"> The resource ID of the private link service that is used to provide virtual machine console access. </param>
        /// <param name="provisioningState"> The provisioning state of the virtual machine console. </param>
        /// <param name="sshPublicKey"> The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in. </param>
        /// <param name="virtualMachineAccessId"> The unique identifier for the virtual machine that is used to access the console. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkCloudVirtualMachineConsoleData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ExtendedLocation extendedLocation, ConsoleDetailedStatus? detailedStatus, string detailedStatusMessage, ConsoleEnabled enabled, DateTimeOffset? expireOn, ResourceIdentifier privateLinkServiceId, ConsoleProvisioningState? provisioningState, NetworkCloudSshPublicKey sshPublicKey, Guid? virtualMachineAccessId, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ExtendedLocation = extendedLocation;
            DetailedStatus = detailedStatus;
            DetailedStatusMessage = detailedStatusMessage;
            Enabled = enabled;
            ExpireOn = expireOn;
            PrivateLinkServiceId = privateLinkServiceId;
            ProvisioningState = provisioningState;
            SshPublicKey = sshPublicKey;
            VirtualMachineAccessId = virtualMachineAccessId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudVirtualMachineConsoleData"/> for deserialization. </summary>
        internal NetworkCloudVirtualMachineConsoleData()
        {
        }

        /// <summary> The extended location of the cluster manager associated with the cluster this virtual machine is created on. </summary>
        public ExtendedLocation ExtendedLocation { get; set; }
        /// <summary> The more detailed status of the console. </summary>
        public ConsoleDetailedStatus? DetailedStatus { get; }
        /// <summary> The descriptive message about the current detailed status. </summary>
        public string DetailedStatusMessage { get; }
        /// <summary> The indicator of whether the console access is enabled. </summary>
        public ConsoleEnabled Enabled { get; set; }
        /// <summary> The date and time after which the key will be disallowed access. </summary>
        public DateTimeOffset? ExpireOn { get; set; }
        /// <summary> The resource ID of the private link service that is used to provide virtual machine console access. </summary>
        public ResourceIdentifier PrivateLinkServiceId { get; }
        /// <summary> The provisioning state of the virtual machine console. </summary>
        public ConsoleProvisioningState? ProvisioningState { get; }
        /// <summary> The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in. </summary>
        internal NetworkCloudSshPublicKey SshPublicKey { get; set; }
        /// <summary> The SSH public key data. </summary>
        public string KeyData
        {
            get => SshPublicKey is null ? default : SshPublicKey.KeyData;
            set => SshPublicKey = new NetworkCloudSshPublicKey(value);
        }

        /// <summary> The unique identifier for the virtual machine that is used to access the console. </summary>
        public Guid? VirtualMachineAccessId { get; }
    }
}
