// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.NetworkCloud.Models;

namespace Azure.ResourceManager.NetworkCloud
{
    /// <summary>
    /// A class representing the NetworkCloudRackSku data model.
    /// RackSku represents the SKU information of the rack.
    /// </summary>
    public partial class NetworkCloudRackSkuData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkCloudRackSkuData"/>. </summary>
        public NetworkCloudRackSkuData()
        {
            ComputeMachines = new ChangeTrackingList<MachineSkuSlot>();
            ControllerMachines = new ChangeTrackingList<MachineSkuSlot>();
            StorageAppliances = new ChangeTrackingList<StorageApplianceSkuSlot>();
            SupportedRackSkuIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudRackSkuData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="computeMachines"> The list of machine SKUs and associated rack slot for the compute-dedicated machines in this rack model. </param>
        /// <param name="controllerMachines"> The list of machine SKUs and associated rack slot for the control-plane dedicated machines in this rack model. </param>
        /// <param name="description"> The free-form text describing the rack. </param>
        /// <param name="maxClusterSlots"> The maximum number of compute racks supported by an aggregator rack. 0 if this is a compute rack or a rack for a single rack cluster(rackType="Single"). </param>
        /// <param name="provisioningState"> The provisioning state of the rack SKU resource. </param>
        /// <param name="rackType"> The type of the rack. </param>
        /// <param name="storageAppliances"> The list of appliance SKUs and associated rack slot for the storage appliance(s) in this rack model. </param>
        /// <param name="supportedRackSkuIds"> The list of supported SKUs if the rack is an aggregator. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkCloudRackSkuData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IReadOnlyList<MachineSkuSlot> computeMachines, IReadOnlyList<MachineSkuSlot> controllerMachines, string description, long? maxClusterSlots, RackSkuProvisioningState? provisioningState, RackSkuType? rackType, IReadOnlyList<StorageApplianceSkuSlot> storageAppliances, IReadOnlyList<string> supportedRackSkuIds, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ComputeMachines = computeMachines;
            ControllerMachines = controllerMachines;
            Description = description;
            MaxClusterSlots = maxClusterSlots;
            ProvisioningState = provisioningState;
            RackType = rackType;
            StorageAppliances = storageAppliances;
            SupportedRackSkuIds = supportedRackSkuIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The list of machine SKUs and associated rack slot for the compute-dedicated machines in this rack model. </summary>
        public IReadOnlyList<MachineSkuSlot> ComputeMachines { get; }
        /// <summary> The list of machine SKUs and associated rack slot for the control-plane dedicated machines in this rack model. </summary>
        public IReadOnlyList<MachineSkuSlot> ControllerMachines { get; }
        /// <summary> The free-form text describing the rack. </summary>
        public string Description { get; }
        /// <summary> The maximum number of compute racks supported by an aggregator rack. 0 if this is a compute rack or a rack for a single rack cluster(rackType="Single"). </summary>
        public long? MaxClusterSlots { get; }
        /// <summary> The provisioning state of the rack SKU resource. </summary>
        public RackSkuProvisioningState? ProvisioningState { get; }
        /// <summary> The type of the rack. </summary>
        public RackSkuType? RackType { get; }
        /// <summary> The list of appliance SKUs and associated rack slot for the storage appliance(s) in this rack model. </summary>
        public IReadOnlyList<StorageApplianceSkuSlot> StorageAppliances { get; }
        /// <summary> The list of supported SKUs if the rack is an aggregator. </summary>
        public IReadOnlyList<string> SupportedRackSkuIds { get; }
    }
}
