// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.NetworkCloud.Models;

namespace Azure.ResourceManager.NetworkCloud
{
    /// <summary>
    /// A class representing the NetworkCloudL3Network data model.
    /// L3Network represents a network that utilizes a single isolation domain set up for layer-3 resources.
    /// </summary>
    public partial class NetworkCloudL3NetworkData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkCloudL3NetworkData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location of the cluster associated with the resource. </param>
        /// <param name="l3IsolationDomainId"> The resource ID of the Network Fabric l3IsolationDomain. </param>
        /// <param name="vlan"> The VLAN from the l3IsolationDomain that is used for this network. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedLocation"/> or <paramref name="l3IsolationDomainId"/> is null. </exception>
        public NetworkCloudL3NetworkData(AzureLocation location, ExtendedLocation extendedLocation, ResourceIdentifier l3IsolationDomainId, long vlan) : base(location)
        {
            Argument.AssertNotNull(extendedLocation, nameof(extendedLocation));
            Argument.AssertNotNull(l3IsolationDomainId, nameof(l3IsolationDomainId));

            ExtendedLocation = extendedLocation;
            AssociatedResourceIds = new ChangeTrackingList<ResourceIdentifier>();
            HybridAksClustersAssociatedIds = new ChangeTrackingList<ResourceIdentifier>();
            L3IsolationDomainId = l3IsolationDomainId;
            VirtualMachinesAssociatedIds = new ChangeTrackingList<ResourceIdentifier>();
            Vlan = vlan;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudL3NetworkData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location of the cluster associated with the resource. </param>
        /// <param name="associatedResourceIds"> The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network. </param>
        /// <param name="clusterId"> The resource ID of the Network Cloud cluster this L3 network is associated with. </param>
        /// <param name="detailedStatus"> The more detailed status of the L3 network. </param>
        /// <param name="detailedStatusMessage"> The descriptive message about the current detailed status. </param>
        /// <param name="hybridAksClustersAssociatedIds"> Field Deprecated. These fields will be empty/omitted. The list of Hybrid AKS cluster resource IDs that are associated with this L3 network. </param>
        /// <param name="hybridAksIpamEnabled"> Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The indicator of whether or not to disable IPAM allocation on the network attachment definition injected into the Hybrid AKS Cluster. </param>
        /// <param name="hybridAksPluginType"> Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS. </param>
        /// <param name="interfaceName"> The default interface name for this L3 network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine. </param>
        /// <param name="ipAllocationType"> The type of the IP address allocation, defaulted to "DualStack". </param>
        /// <param name="ipv4ConnectedPrefix">
        /// The IPV4 prefix (CIDR) assigned to this L3 network. Required when the IP allocation type
        /// is IPV4 or DualStack.
        /// </param>
        /// <param name="ipv6ConnectedPrefix">
        /// The IPV6 prefix (CIDR) assigned to this L3 network. Required when the IP allocation type
        /// is IPV6 or DualStack.
        /// </param>
        /// <param name="l3IsolationDomainId"> The resource ID of the Network Fabric l3IsolationDomain. </param>
        /// <param name="provisioningState"> The provisioning state of the L3 network. </param>
        /// <param name="virtualMachinesAssociatedIds"> Field Deprecated. These fields will be empty/omitted. The list of virtual machine resource IDs, excluding any Hybrid AKS virtual machines, that are currently using this L3 network. </param>
        /// <param name="vlan"> The VLAN from the l3IsolationDomain that is used for this network. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkCloudL3NetworkData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ExtendedLocation extendedLocation, IReadOnlyList<ResourceIdentifier> associatedResourceIds, ResourceIdentifier clusterId, L3NetworkDetailedStatus? detailedStatus, string detailedStatusMessage, IReadOnlyList<ResourceIdentifier> hybridAksClustersAssociatedIds, HybridAksIpamEnabled? hybridAksIpamEnabled, HybridAksPluginType? hybridAksPluginType, string interfaceName, IPAllocationType? ipAllocationType, string ipv4ConnectedPrefix, string ipv6ConnectedPrefix, ResourceIdentifier l3IsolationDomainId, L3NetworkProvisioningState? provisioningState, IReadOnlyList<ResourceIdentifier> virtualMachinesAssociatedIds, long vlan, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ExtendedLocation = extendedLocation;
            AssociatedResourceIds = associatedResourceIds;
            ClusterId = clusterId;
            DetailedStatus = detailedStatus;
            DetailedStatusMessage = detailedStatusMessage;
            HybridAksClustersAssociatedIds = hybridAksClustersAssociatedIds;
            HybridAksIpamEnabled = hybridAksIpamEnabled;
            HybridAksPluginType = hybridAksPluginType;
            InterfaceName = interfaceName;
            IPAllocationType = ipAllocationType;
            IPv4ConnectedPrefix = ipv4ConnectedPrefix;
            IPv6ConnectedPrefix = ipv6ConnectedPrefix;
            L3IsolationDomainId = l3IsolationDomainId;
            ProvisioningState = provisioningState;
            VirtualMachinesAssociatedIds = virtualMachinesAssociatedIds;
            Vlan = vlan;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudL3NetworkData"/> for deserialization. </summary>
        internal NetworkCloudL3NetworkData()
        {
        }

        /// <summary> The extended location of the cluster associated with the resource. </summary>
        public ExtendedLocation ExtendedLocation { get; set; }
        /// <summary> The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network. </summary>
        public IReadOnlyList<ResourceIdentifier> AssociatedResourceIds { get; }
        /// <summary> The resource ID of the Network Cloud cluster this L3 network is associated with. </summary>
        public ResourceIdentifier ClusterId { get; }
        /// <summary> The more detailed status of the L3 network. </summary>
        public L3NetworkDetailedStatus? DetailedStatus { get; }
        /// <summary> The descriptive message about the current detailed status. </summary>
        public string DetailedStatusMessage { get; }
        /// <summary> Field Deprecated. These fields will be empty/omitted. The list of Hybrid AKS cluster resource IDs that are associated with this L3 network. </summary>
        public IReadOnlyList<ResourceIdentifier> HybridAksClustersAssociatedIds { get; }
        /// <summary> Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The indicator of whether or not to disable IPAM allocation on the network attachment definition injected into the Hybrid AKS Cluster. </summary>
        public HybridAksIpamEnabled? HybridAksIpamEnabled { get; set; }
        /// <summary> Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS. </summary>
        public HybridAksPluginType? HybridAksPluginType { get; set; }
        /// <summary> The default interface name for this L3 network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine. </summary>
        public string InterfaceName { get; set; }
        /// <summary> The type of the IP address allocation, defaulted to "DualStack". </summary>
        public IPAllocationType? IPAllocationType { get; set; }
        /// <summary>
        /// The IPV4 prefix (CIDR) assigned to this L3 network. Required when the IP allocation type
        /// is IPV4 or DualStack.
        /// </summary>
        public string IPv4ConnectedPrefix { get; set; }
        /// <summary>
        /// The IPV6 prefix (CIDR) assigned to this L3 network. Required when the IP allocation type
        /// is IPV6 or DualStack.
        /// </summary>
        public string IPv6ConnectedPrefix { get; set; }
        /// <summary> The resource ID of the Network Fabric l3IsolationDomain. </summary>
        public ResourceIdentifier L3IsolationDomainId { get; set; }
        /// <summary> The provisioning state of the L3 network. </summary>
        public L3NetworkProvisioningState? ProvisioningState { get; }
        /// <summary> Field Deprecated. These fields will be empty/omitted. The list of virtual machine resource IDs, excluding any Hybrid AKS virtual machines, that are currently using this L3 network. </summary>
        public IReadOnlyList<ResourceIdentifier> VirtualMachinesAssociatedIds { get; }
        /// <summary> The VLAN from the l3IsolationDomain that is used for this network. </summary>
        public long Vlan { get; set; }
    }
}
