// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.NetworkCloud.Models;

namespace Azure.ResourceManager.NetworkCloud
{
    /// <summary>
    /// A class representing the NetworkCloudBareMetalMachine data model.
    /// BareMetalMachine represents the physical machine in the rack.
    /// </summary>
    public partial class NetworkCloudBareMetalMachineData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkCloudBareMetalMachineData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location of the cluster associated with the resource. </param>
        /// <param name="bmcConnectionString"> The connection string for the baseboard management controller including IP address and protocol. </param>
        /// <param name="bmcCredentials"> The credentials of the baseboard management controller on this bare metal machine. </param>
        /// <param name="bmcMacAddress"> The MAC address of the BMC device. </param>
        /// <param name="bootMacAddress"> The MAC address of a NIC connected to the PXE network. </param>
        /// <param name="machineDetails"> The custom details provided by the customer. </param>
        /// <param name="machineName"> The OS-level hostname assigned to this machine. </param>
        /// <param name="machineSkuId"> The unique internal identifier of the bare metal machine SKU. </param>
        /// <param name="rackId"> The resource ID of the rack where this bare metal machine resides. </param>
        /// <param name="rackSlot"> The rack slot in which this bare metal machine is located, ordered from the bottom up i.e. the lowest slot is 1. </param>
        /// <param name="serialNumber"> The serial number of the bare metal machine. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedLocation"/>, <paramref name="bmcConnectionString"/>, <paramref name="bmcCredentials"/>, <paramref name="bmcMacAddress"/>, <paramref name="bootMacAddress"/>, <paramref name="machineDetails"/>, <paramref name="machineName"/>, <paramref name="machineSkuId"/>, <paramref name="rackId"/> or <paramref name="serialNumber"/> is null. </exception>
        public NetworkCloudBareMetalMachineData(AzureLocation location, ExtendedLocation extendedLocation, string bmcConnectionString, AdministrativeCredentials bmcCredentials, string bmcMacAddress, string bootMacAddress, string machineDetails, string machineName, string machineSkuId, ResourceIdentifier rackId, long rackSlot, string serialNumber) : base(location)
        {
            Argument.AssertNotNull(extendedLocation, nameof(extendedLocation));
            Argument.AssertNotNull(bmcConnectionString, nameof(bmcConnectionString));
            Argument.AssertNotNull(bmcCredentials, nameof(bmcCredentials));
            Argument.AssertNotNull(bmcMacAddress, nameof(bmcMacAddress));
            Argument.AssertNotNull(bootMacAddress, nameof(bootMacAddress));
            Argument.AssertNotNull(machineDetails, nameof(machineDetails));
            Argument.AssertNotNull(machineName, nameof(machineName));
            Argument.AssertNotNull(machineSkuId, nameof(machineSkuId));
            Argument.AssertNotNull(rackId, nameof(rackId));
            Argument.AssertNotNull(serialNumber, nameof(serialNumber));

            ExtendedLocation = extendedLocation;
            AssociatedResourceIds = new ChangeTrackingList<ResourceIdentifier>();
            BmcConnectionString = bmcConnectionString;
            BmcCredentials = bmcCredentials;
            BmcMacAddress = bmcMacAddress;
            BootMacAddress = bootMacAddress;
            HybridAksClustersAssociatedIds = new ChangeTrackingList<string>();
            MachineDetails = machineDetails;
            MachineName = machineName;
            MachineSkuId = machineSkuId;
            RackId = rackId;
            RackSlot = rackSlot;
            SerialNumber = serialNumber;
            VirtualMachinesAssociatedIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudBareMetalMachineData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location of the cluster associated with the resource. </param>
        /// <param name="associatedResourceIds"> The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network. </param>
        /// <param name="bmcConnectionString"> The connection string for the baseboard management controller including IP address and protocol. </param>
        /// <param name="bmcCredentials"> The credentials of the baseboard management controller on this bare metal machine. </param>
        /// <param name="bmcMacAddress"> The MAC address of the BMC device. </param>
        /// <param name="bootMacAddress"> The MAC address of a NIC connected to the PXE network. </param>
        /// <param name="clusterId"> The resource ID of the cluster this bare metal machine is associated with. </param>
        /// <param name="cordonStatus"> The cordon status of the bare metal machine. </param>
        /// <param name="detailedStatus"> The more detailed status of the bare metal machine. </param>
        /// <param name="detailedStatusMessage"> The descriptive message about the current detailed status. </param>
        /// <param name="hardwareInventory"> The hardware inventory, including information acquired from the model/sku information and from the ironic inspector. </param>
        /// <param name="hardwareValidationStatus"> The details of the latest hardware validation performed for this bare metal machine. </param>
        /// <param name="hybridAksClustersAssociatedIds"> Field Deprecated. These fields will be empty/omitted. The list of the resource IDs for the HybridAksClusters that have nodes hosted on this bare metal machine. </param>
        /// <param name="kubernetesNodeName"> The name of this machine represented by the host object in the Cluster's Kubernetes control plane. </param>
        /// <param name="kubernetesVersion"> The version of Kubernetes running on this machine. </param>
        /// <param name="machineDetails"> The custom details provided by the customer. </param>
        /// <param name="machineName"> The OS-level hostname assigned to this machine. </param>
        /// <param name="machineSkuId"> The unique internal identifier of the bare metal machine SKU. </param>
        /// <param name="oamIPv4Address"> The IPv4 address that is assigned to the bare metal machine during the cluster deployment. </param>
        /// <param name="oamIPv6Address"> The IPv6 address that is assigned to the bare metal machine during the cluster deployment. </param>
        /// <param name="osImage"> The image that is currently provisioned to the OS disk. </param>
        /// <param name="powerState"> The power state derived from the baseboard management controller. </param>
        /// <param name="provisioningState"> The provisioning state of the bare metal machine. </param>
        /// <param name="rackId"> The resource ID of the rack where this bare metal machine resides. </param>
        /// <param name="rackSlot"> The rack slot in which this bare metal machine is located, ordered from the bottom up i.e. the lowest slot is 1. </param>
        /// <param name="readyState"> The indicator of whether the bare metal machine is ready to receive workloads. </param>
        /// <param name="serialNumber"> The serial number of the bare metal machine. </param>
        /// <param name="serviceTag"> The discovered value of the machine's service tag. </param>
        /// <param name="virtualMachinesAssociatedIds"> Field Deprecated. These fields will be empty/omitted. The list of the resource IDs for the VirtualMachines that are hosted on this bare metal machine. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkCloudBareMetalMachineData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ExtendedLocation extendedLocation, IReadOnlyList<ResourceIdentifier> associatedResourceIds, string bmcConnectionString, AdministrativeCredentials bmcCredentials, string bmcMacAddress, string bootMacAddress, ResourceIdentifier clusterId, BareMetalMachineCordonStatus? cordonStatus, BareMetalMachineDetailedStatus? detailedStatus, string detailedStatusMessage, HardwareInventory hardwareInventory, HardwareValidationStatus hardwareValidationStatus, IReadOnlyList<string> hybridAksClustersAssociatedIds, string kubernetesNodeName, string kubernetesVersion, string machineDetails, string machineName, string machineSkuId, IPAddress oamIPv4Address, string oamIPv6Address, string osImage, BareMetalMachinePowerState? powerState, BareMetalMachineProvisioningState? provisioningState, ResourceIdentifier rackId, long rackSlot, BareMetalMachineReadyState? readyState, string serialNumber, string serviceTag, IReadOnlyList<string> virtualMachinesAssociatedIds, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ExtendedLocation = extendedLocation;
            AssociatedResourceIds = associatedResourceIds;
            BmcConnectionString = bmcConnectionString;
            BmcCredentials = bmcCredentials;
            BmcMacAddress = bmcMacAddress;
            BootMacAddress = bootMacAddress;
            ClusterId = clusterId;
            CordonStatus = cordonStatus;
            DetailedStatus = detailedStatus;
            DetailedStatusMessage = detailedStatusMessage;
            HardwareInventory = hardwareInventory;
            HardwareValidationStatus = hardwareValidationStatus;
            HybridAksClustersAssociatedIds = hybridAksClustersAssociatedIds;
            KubernetesNodeName = kubernetesNodeName;
            KubernetesVersion = kubernetesVersion;
            MachineDetails = machineDetails;
            MachineName = machineName;
            MachineSkuId = machineSkuId;
            OamIPv4Address = oamIPv4Address;
            OamIPv6Address = oamIPv6Address;
            OSImage = osImage;
            PowerState = powerState;
            ProvisioningState = provisioningState;
            RackId = rackId;
            RackSlot = rackSlot;
            ReadyState = readyState;
            SerialNumber = serialNumber;
            ServiceTag = serviceTag;
            VirtualMachinesAssociatedIds = virtualMachinesAssociatedIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudBareMetalMachineData"/> for deserialization. </summary>
        internal NetworkCloudBareMetalMachineData()
        {
        }

        /// <summary> The extended location of the cluster associated with the resource. </summary>
        public ExtendedLocation ExtendedLocation { get; set; }
        /// <summary> The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network. </summary>
        public IReadOnlyList<ResourceIdentifier> AssociatedResourceIds { get; }
        /// <summary> The connection string for the baseboard management controller including IP address and protocol. </summary>
        public string BmcConnectionString { get; set; }
        /// <summary> The credentials of the baseboard management controller on this bare metal machine. </summary>
        public AdministrativeCredentials BmcCredentials { get; set; }
        /// <summary> The MAC address of the BMC device. </summary>
        public string BmcMacAddress { get; set; }
        /// <summary> The MAC address of a NIC connected to the PXE network. </summary>
        public string BootMacAddress { get; set; }
        /// <summary> The resource ID of the cluster this bare metal machine is associated with. </summary>
        public ResourceIdentifier ClusterId { get; }
        /// <summary> The cordon status of the bare metal machine. </summary>
        public BareMetalMachineCordonStatus? CordonStatus { get; }
        /// <summary> The more detailed status of the bare metal machine. </summary>
        public BareMetalMachineDetailedStatus? DetailedStatus { get; }
        /// <summary> The descriptive message about the current detailed status. </summary>
        public string DetailedStatusMessage { get; }
        /// <summary> The hardware inventory, including information acquired from the model/sku information and from the ironic inspector. </summary>
        public HardwareInventory HardwareInventory { get; }
        /// <summary> The details of the latest hardware validation performed for this bare metal machine. </summary>
        public HardwareValidationStatus HardwareValidationStatus { get; }
        /// <summary> Field Deprecated. These fields will be empty/omitted. The list of the resource IDs for the HybridAksClusters that have nodes hosted on this bare metal machine. </summary>
        public IReadOnlyList<string> HybridAksClustersAssociatedIds { get; }
        /// <summary> The name of this machine represented by the host object in the Cluster's Kubernetes control plane. </summary>
        public string KubernetesNodeName { get; }
        /// <summary> The version of Kubernetes running on this machine. </summary>
        public string KubernetesVersion { get; }
        /// <summary> The custom details provided by the customer. </summary>
        public string MachineDetails { get; set; }
        /// <summary> The OS-level hostname assigned to this machine. </summary>
        public string MachineName { get; set; }
        /// <summary> The unique internal identifier of the bare metal machine SKU. </summary>
        public string MachineSkuId { get; set; }
        /// <summary> The IPv4 address that is assigned to the bare metal machine during the cluster deployment. </summary>
        public IPAddress OamIPv4Address { get; }
        /// <summary> The IPv6 address that is assigned to the bare metal machine during the cluster deployment. </summary>
        public string OamIPv6Address { get; }
        /// <summary> The image that is currently provisioned to the OS disk. </summary>
        public string OSImage { get; }
        /// <summary> The power state derived from the baseboard management controller. </summary>
        public BareMetalMachinePowerState? PowerState { get; }
        /// <summary> The provisioning state of the bare metal machine. </summary>
        public BareMetalMachineProvisioningState? ProvisioningState { get; }
        /// <summary> The resource ID of the rack where this bare metal machine resides. </summary>
        public ResourceIdentifier RackId { get; set; }
        /// <summary> The rack slot in which this bare metal machine is located, ordered from the bottom up i.e. the lowest slot is 1. </summary>
        public long RackSlot { get; set; }
        /// <summary> The indicator of whether the bare metal machine is ready to receive workloads. </summary>
        public BareMetalMachineReadyState? ReadyState { get; }
        /// <summary> The serial number of the bare metal machine. </summary>
        public string SerialNumber { get; set; }
        /// <summary> The discovered value of the machine's service tag. </summary>
        public string ServiceTag { get; }
        /// <summary> Field Deprecated. These fields will be empty/omitted. The list of the resource IDs for the VirtualMachines that are hosted on this bare metal machine. </summary>
        public IReadOnlyList<string> VirtualMachinesAssociatedIds { get; }
    }
}
