// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The provisioning state of the volume. </summary>
    public readonly partial struct VolumeProvisioningState : IEquatable<VolumeProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VolumeProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VolumeProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string AcceptedValue = "Accepted";

        /// <summary> Succeeded. </summary>
        public static VolumeProvisioningState Succeeded { get; } = new VolumeProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static VolumeProvisioningState Failed { get; } = new VolumeProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static VolumeProvisioningState Canceled { get; } = new VolumeProvisioningState(CanceledValue);
        /// <summary> Provisioning. </summary>
        public static VolumeProvisioningState Provisioning { get; } = new VolumeProvisioningState(ProvisioningValue);
        /// <summary> Accepted. </summary>
        public static VolumeProvisioningState Accepted { get; } = new VolumeProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="VolumeProvisioningState"/> values are the same. </summary>
        public static bool operator ==(VolumeProvisioningState left, VolumeProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VolumeProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(VolumeProvisioningState left, VolumeProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VolumeProvisioningState"/>. </summary>
        public static implicit operator VolumeProvisioningState(string value) => new VolumeProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VolumeProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VolumeProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
