// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The indicator of whether the hint is a hard or soft requirement during scheduling. </summary>
    public readonly partial struct VirtualMachineSchedulingExecution : IEquatable<VirtualMachineSchedulingExecution>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualMachineSchedulingExecution"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualMachineSchedulingExecution(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HardValue = "Hard";
        private const string SoftValue = "Soft";

        /// <summary> Hard. </summary>
        public static VirtualMachineSchedulingExecution Hard { get; } = new VirtualMachineSchedulingExecution(HardValue);
        /// <summary> Soft. </summary>
        public static VirtualMachineSchedulingExecution Soft { get; } = new VirtualMachineSchedulingExecution(SoftValue);
        /// <summary> Determines if two <see cref="VirtualMachineSchedulingExecution"/> values are the same. </summary>
        public static bool operator ==(VirtualMachineSchedulingExecution left, VirtualMachineSchedulingExecution right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualMachineSchedulingExecution"/> values are not the same. </summary>
        public static bool operator !=(VirtualMachineSchedulingExecution left, VirtualMachineSchedulingExecution right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualMachineSchedulingExecution"/>. </summary>
        public static implicit operator VirtualMachineSchedulingExecution(string value) => new VirtualMachineSchedulingExecution(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualMachineSchedulingExecution other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualMachineSchedulingExecution other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
