// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The specification of whether this hint supports affinity or anti-affinity with the referenced resources. </summary>
    public readonly partial struct VirtualMachinePlacementHintType : IEquatable<VirtualMachinePlacementHintType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualMachinePlacementHintType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualMachinePlacementHintType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AffinityValue = "Affinity";
        private const string AntiAffinityValue = "AntiAffinity";

        /// <summary> Affinity. </summary>
        public static VirtualMachinePlacementHintType Affinity { get; } = new VirtualMachinePlacementHintType(AffinityValue);
        /// <summary> AntiAffinity. </summary>
        public static VirtualMachinePlacementHintType AntiAffinity { get; } = new VirtualMachinePlacementHintType(AntiAffinityValue);
        /// <summary> Determines if two <see cref="VirtualMachinePlacementHintType"/> values are the same. </summary>
        public static bool operator ==(VirtualMachinePlacementHintType left, VirtualMachinePlacementHintType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualMachinePlacementHintType"/> values are not the same. </summary>
        public static bool operator !=(VirtualMachinePlacementHintType left, VirtualMachinePlacementHintType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualMachinePlacementHintType"/>. </summary>
        public static implicit operator VirtualMachinePlacementHintType(string value) => new VirtualMachinePlacementHintType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualMachinePlacementHintType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualMachinePlacementHintType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
