// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The scope for the virtual machine affinity or anti-affinity placement hint. It should always be "Machine" in the case of node affinity. </summary>
    public readonly partial struct VirtualMachinePlacementHintPodAffinityScope : IEquatable<VirtualMachinePlacementHintPodAffinityScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualMachinePlacementHintPodAffinityScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualMachinePlacementHintPodAffinityScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RackValue = "Rack";
        private const string MachineValue = "Machine";

        /// <summary> Rack. </summary>
        public static VirtualMachinePlacementHintPodAffinityScope Rack { get; } = new VirtualMachinePlacementHintPodAffinityScope(RackValue);
        /// <summary> Machine. </summary>
        public static VirtualMachinePlacementHintPodAffinityScope Machine { get; } = new VirtualMachinePlacementHintPodAffinityScope(MachineValue);
        /// <summary> Determines if two <see cref="VirtualMachinePlacementHintPodAffinityScope"/> values are the same. </summary>
        public static bool operator ==(VirtualMachinePlacementHintPodAffinityScope left, VirtualMachinePlacementHintPodAffinityScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualMachinePlacementHintPodAffinityScope"/> values are not the same. </summary>
        public static bool operator !=(VirtualMachinePlacementHintPodAffinityScope left, VirtualMachinePlacementHintPodAffinityScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualMachinePlacementHintPodAffinityScope"/>. </summary>
        public static implicit operator VirtualMachinePlacementHintPodAffinityScope(string value) => new VirtualMachinePlacementHintPodAffinityScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualMachinePlacementHintPodAffinityScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualMachinePlacementHintPodAffinityScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
