// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    public partial class VirtualMachinePlacementHint : IUtf8JsonSerializable, IJsonModel<VirtualMachinePlacementHint>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VirtualMachinePlacementHint>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VirtualMachinePlacementHint>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VirtualMachinePlacementHint>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VirtualMachinePlacementHint)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("hintType"u8);
            writer.WriteStringValue(HintType.ToString());
            writer.WritePropertyName("resourceId"u8);
            writer.WriteStringValue(ResourceId);
            writer.WritePropertyName("schedulingExecution"u8);
            writer.WriteStringValue(SchedulingExecution.ToString());
            writer.WritePropertyName("scope"u8);
            writer.WriteStringValue(Scope.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        VirtualMachinePlacementHint IJsonModel<VirtualMachinePlacementHint>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VirtualMachinePlacementHint>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VirtualMachinePlacementHint)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVirtualMachinePlacementHint(document.RootElement, options);
        }

        internal static VirtualMachinePlacementHint DeserializeVirtualMachinePlacementHint(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            VirtualMachinePlacementHintType hintType = default;
            ResourceIdentifier resourceId = default;
            VirtualMachineSchedulingExecution schedulingExecution = default;
            VirtualMachinePlacementHintPodAffinityScope scope = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("hintType"u8))
                {
                    hintType = new VirtualMachinePlacementHintType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("resourceId"u8))
                {
                    resourceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("schedulingExecution"u8))
                {
                    schedulingExecution = new VirtualMachineSchedulingExecution(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("scope"u8))
                {
                    scope = new VirtualMachinePlacementHintPodAffinityScope(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VirtualMachinePlacementHint(hintType, resourceId, schedulingExecution, scope, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<VirtualMachinePlacementHint>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VirtualMachinePlacementHint>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VirtualMachinePlacementHint)} does not support writing '{options.Format}' format.");
            }
        }

        VirtualMachinePlacementHint IPersistableModel<VirtualMachinePlacementHint>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VirtualMachinePlacementHint>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVirtualMachinePlacementHint(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VirtualMachinePlacementHint)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VirtualMachinePlacementHint>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
