// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> Field Deprecated, the value will be ignored if provided. The indicator of whether one of the specified CPU cores is isolated to run the emulator thread for this virtual machine. </summary>
    public readonly partial struct VirtualMachineIsolateEmulatorThread : IEquatable<VirtualMachineIsolateEmulatorThread>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualMachineIsolateEmulatorThread"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualMachineIsolateEmulatorThread(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static VirtualMachineIsolateEmulatorThread True { get; } = new VirtualMachineIsolateEmulatorThread(TrueValue);
        /// <summary> False. </summary>
        public static VirtualMachineIsolateEmulatorThread False { get; } = new VirtualMachineIsolateEmulatorThread(FalseValue);
        /// <summary> Determines if two <see cref="VirtualMachineIsolateEmulatorThread"/> values are the same. </summary>
        public static bool operator ==(VirtualMachineIsolateEmulatorThread left, VirtualMachineIsolateEmulatorThread right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualMachineIsolateEmulatorThread"/> values are not the same. </summary>
        public static bool operator !=(VirtualMachineIsolateEmulatorThread left, VirtualMachineIsolateEmulatorThread right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualMachineIsolateEmulatorThread"/>. </summary>
        public static implicit operator VirtualMachineIsolateEmulatorThread(string value) => new VirtualMachineIsolateEmulatorThread(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualMachineIsolateEmulatorThread other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualMachineIsolateEmulatorThread other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
