// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The more detailed status of the virtual machine. </summary>
    public readonly partial struct VirtualMachineDetailedStatus : IEquatable<VirtualMachineDetailedStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualMachineDetailedStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualMachineDetailedStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AvailableValue = "Available";
        private const string ErrorValue = "Error";
        private const string ProvisioningValue = "Provisioning";
        private const string RunningValue = "Running";
        private const string SchedulingValue = "Scheduling";
        private const string StoppedValue = "Stopped";
        private const string TerminatingValue = "Terminating";
        private const string UnknownValue = "Unknown";

        /// <summary> Available. </summary>
        public static VirtualMachineDetailedStatus Available { get; } = new VirtualMachineDetailedStatus(AvailableValue);
        /// <summary> Error. </summary>
        public static VirtualMachineDetailedStatus Error { get; } = new VirtualMachineDetailedStatus(ErrorValue);
        /// <summary> Provisioning. </summary>
        public static VirtualMachineDetailedStatus Provisioning { get; } = new VirtualMachineDetailedStatus(ProvisioningValue);
        /// <summary> Running. </summary>
        public static VirtualMachineDetailedStatus Running { get; } = new VirtualMachineDetailedStatus(RunningValue);
        /// <summary> Scheduling. </summary>
        public static VirtualMachineDetailedStatus Scheduling { get; } = new VirtualMachineDetailedStatus(SchedulingValue);
        /// <summary> Stopped. </summary>
        public static VirtualMachineDetailedStatus Stopped { get; } = new VirtualMachineDetailedStatus(StoppedValue);
        /// <summary> Terminating. </summary>
        public static VirtualMachineDetailedStatus Terminating { get; } = new VirtualMachineDetailedStatus(TerminatingValue);
        /// <summary> Unknown. </summary>
        public static VirtualMachineDetailedStatus Unknown { get; } = new VirtualMachineDetailedStatus(UnknownValue);
        /// <summary> Determines if two <see cref="VirtualMachineDetailedStatus"/> values are the same. </summary>
        public static bool operator ==(VirtualMachineDetailedStatus left, VirtualMachineDetailedStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualMachineDetailedStatus"/> values are not the same. </summary>
        public static bool operator !=(VirtualMachineDetailedStatus left, VirtualMachineDetailedStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualMachineDetailedStatus"/>. </summary>
        public static implicit operator VirtualMachineDetailedStatus(string value) => new VirtualMachineDetailedStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualMachineDetailedStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualMachineDetailedStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
