// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> Selects the boot method for the virtual machine. </summary>
    public readonly partial struct VirtualMachineBootMethod : IEquatable<VirtualMachineBootMethod>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualMachineBootMethod"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualMachineBootMethod(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UefiValue = "UEFI";
        private const string BiosValue = "BIOS";

        /// <summary> UEFI. </summary>
        public static VirtualMachineBootMethod Uefi { get; } = new VirtualMachineBootMethod(UefiValue);
        /// <summary> BIOS. </summary>
        public static VirtualMachineBootMethod Bios { get; } = new VirtualMachineBootMethod(BiosValue);
        /// <summary> Determines if two <see cref="VirtualMachineBootMethod"/> values are the same. </summary>
        public static bool operator ==(VirtualMachineBootMethod left, VirtualMachineBootMethod right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualMachineBootMethod"/> values are not the same. </summary>
        public static bool operator !=(VirtualMachineBootMethod left, VirtualMachineBootMethod right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualMachineBootMethod"/>. </summary>
        public static implicit operator VirtualMachineBootMethod(string value) => new VirtualMachineBootMethod(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualMachineBootMethod other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualMachineBootMethod other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
