// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> Selection of how the threshold should be evaluated. </summary>
    public readonly partial struct ValidationThresholdType : IEquatable<ValidationThresholdType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ValidationThresholdType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ValidationThresholdType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountSuccessValue = "CountSuccess";
        private const string PercentSuccessValue = "PercentSuccess";

        /// <summary> CountSuccess. </summary>
        public static ValidationThresholdType CountSuccess { get; } = new ValidationThresholdType(CountSuccessValue);
        /// <summary> PercentSuccess. </summary>
        public static ValidationThresholdType PercentSuccess { get; } = new ValidationThresholdType(PercentSuccessValue);
        /// <summary> Determines if two <see cref="ValidationThresholdType"/> values are the same. </summary>
        public static bool operator ==(ValidationThresholdType left, ValidationThresholdType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ValidationThresholdType"/> values are not the same. </summary>
        public static bool operator !=(ValidationThresholdType left, ValidationThresholdType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ValidationThresholdType"/>. </summary>
        public static implicit operator ValidationThresholdType(string value) => new ValidationThresholdType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ValidationThresholdType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ValidationThresholdType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
