// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> Selection of how the type evaluation is applied to the cluster calculation. </summary>
    public readonly partial struct ValidationThresholdGrouping : IEquatable<ValidationThresholdGrouping>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ValidationThresholdGrouping"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ValidationThresholdGrouping(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PerClusterValue = "PerCluster";
        private const string PerRackValue = "PerRack";

        /// <summary> PerCluster. </summary>
        public static ValidationThresholdGrouping PerCluster { get; } = new ValidationThresholdGrouping(PerClusterValue);
        /// <summary> PerRack. </summary>
        public static ValidationThresholdGrouping PerRack { get; } = new ValidationThresholdGrouping(PerRackValue);
        /// <summary> Determines if two <see cref="ValidationThresholdGrouping"/> values are the same. </summary>
        public static bool operator ==(ValidationThresholdGrouping left, ValidationThresholdGrouping right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ValidationThresholdGrouping"/> values are not the same. </summary>
        public static bool operator !=(ValidationThresholdGrouping left, ValidationThresholdGrouping right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ValidationThresholdGrouping"/>. </summary>
        public static implicit operator ValidationThresholdGrouping(string value) => new ValidationThresholdGrouping(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ValidationThresholdGrouping other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ValidationThresholdGrouping other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
