// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> ValidationThreshold indicates allowed machine and node hardware and deployment failures. </summary>
    public partial class ValidationThreshold
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ValidationThreshold"/>. </summary>
        /// <param name="grouping"> Selection of how the type evaluation is applied to the cluster calculation. </param>
        /// <param name="thresholdType"> Selection of how the threshold should be evaluated. </param>
        /// <param name="value"> The numeric threshold value. </param>
        public ValidationThreshold(ValidationThresholdGrouping grouping, ValidationThresholdType thresholdType, long value)
        {
            Grouping = grouping;
            ThresholdType = thresholdType;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="ValidationThreshold"/>. </summary>
        /// <param name="grouping"> Selection of how the type evaluation is applied to the cluster calculation. </param>
        /// <param name="thresholdType"> Selection of how the threshold should be evaluated. </param>
        /// <param name="value"> The numeric threshold value. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ValidationThreshold(ValidationThresholdGrouping grouping, ValidationThresholdType thresholdType, long value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Grouping = grouping;
            ThresholdType = thresholdType;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ValidationThreshold"/> for deserialization. </summary>
        internal ValidationThreshold()
        {
        }

        /// <summary> Selection of how the type evaluation is applied to the cluster calculation. </summary>
        public ValidationThresholdGrouping Grouping { get; set; }
        /// <summary> Selection of how the threshold should be evaluated. </summary>
        public ValidationThresholdType ThresholdType { get; set; }
        /// <summary> The numeric threshold value. </summary>
        public long Value { get; set; }
    }
}
