// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The provisioning state of the storage appliance. </summary>
    public readonly partial struct StorageApplianceProvisioningState : IEquatable<StorageApplianceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageApplianceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageApplianceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string AcceptedValue = "Accepted";

        /// <summary> Succeeded. </summary>
        public static StorageApplianceProvisioningState Succeeded { get; } = new StorageApplianceProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static StorageApplianceProvisioningState Failed { get; } = new StorageApplianceProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static StorageApplianceProvisioningState Canceled { get; } = new StorageApplianceProvisioningState(CanceledValue);
        /// <summary> Provisioning. </summary>
        public static StorageApplianceProvisioningState Provisioning { get; } = new StorageApplianceProvisioningState(ProvisioningValue);
        /// <summary> Accepted. </summary>
        public static StorageApplianceProvisioningState Accepted { get; } = new StorageApplianceProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="StorageApplianceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(StorageApplianceProvisioningState left, StorageApplianceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageApplianceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(StorageApplianceProvisioningState left, StorageApplianceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageApplianceProvisioningState"/>. </summary>
        public static implicit operator StorageApplianceProvisioningState(string value) => new StorageApplianceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageApplianceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageApplianceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
