// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The indicator of whether to skip the graceful OS shutdown and power off the virtual machine immediately. </summary>
    public readonly partial struct SkipShutdown : IEquatable<SkipShutdown>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SkipShutdown"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SkipShutdown(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static SkipShutdown True { get; } = new SkipShutdown(TrueValue);
        /// <summary> False. </summary>
        public static SkipShutdown False { get; } = new SkipShutdown(FalseValue);
        /// <summary> Determines if two <see cref="SkipShutdown"/> values are the same. </summary>
        public static bool operator ==(SkipShutdown left, SkipShutdown right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SkipShutdown"/> values are not the same. </summary>
        public static bool operator !=(SkipShutdown left, SkipShutdown right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SkipShutdown"/>. </summary>
        public static implicit operator SkipShutdown(string value) => new SkipShutdown(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SkipShutdown other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SkipShutdown other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
