// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> ServiceLoadBalancerBgpPeer represents the configuration of the BGP service load balancer for the Kubernetes cluster. </summary>
    public partial class ServiceLoadBalancerBgpPeer
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ServiceLoadBalancerBgpPeer"/>. </summary>
        /// <param name="name"> The name used to identify this BGP peer for association with a BGP advertisement. </param>
        /// <param name="peerAddress"> The IPv4 or IPv6 address used to connect this BGP session. </param>
        /// <param name="peerAsn"> The autonomous system number expected from the remote end of the BGP session. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="peerAddress"/> is null. </exception>
        public ServiceLoadBalancerBgpPeer(string name, string peerAddress, long peerAsn)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(peerAddress, nameof(peerAddress));

            Name = name;
            PeerAddress = peerAddress;
            PeerAsn = peerAsn;
        }

        /// <summary> Initializes a new instance of <see cref="ServiceLoadBalancerBgpPeer"/>. </summary>
        /// <param name="bfdEnabled"> The indicator of BFD enablement for this BgpPeer. </param>
        /// <param name="bgpMultiHop"> The indicator to enable multi-hop peering support. </param>
        /// <param name="holdTime"> The requested BGP hold time value. This field uses ISO 8601 duration format, for example P1H. </param>
        /// <param name="keepAliveTime"> The requested BGP keepalive time value. This field uses ISO 8601 duration format, for example P1H. </param>
        /// <param name="myAsn"> The autonomous system number used for the local end of the BGP session. </param>
        /// <param name="name"> The name used to identify this BGP peer for association with a BGP advertisement. </param>
        /// <param name="password"> The authentication password for routers enforcing TCP MD5 authenticated sessions. </param>
        /// <param name="peerAddress"> The IPv4 or IPv6 address used to connect this BGP session. </param>
        /// <param name="peerAsn"> The autonomous system number expected from the remote end of the BGP session. </param>
        /// <param name="peerPort"> The port used to connect this BGP session. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ServiceLoadBalancerBgpPeer(BfdEnabled? bfdEnabled, BgpMultiHop? bgpMultiHop, string holdTime, string keepAliveTime, long? myAsn, string name, string password, string peerAddress, long peerAsn, long? peerPort, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BfdEnabled = bfdEnabled;
            BgpMultiHop = bgpMultiHop;
            HoldTime = holdTime;
            KeepAliveTime = keepAliveTime;
            MyAsn = myAsn;
            Name = name;
            Password = password;
            PeerAddress = peerAddress;
            PeerAsn = peerAsn;
            PeerPort = peerPort;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ServiceLoadBalancerBgpPeer"/> for deserialization. </summary>
        internal ServiceLoadBalancerBgpPeer()
        {
        }

        /// <summary> The indicator of BFD enablement for this BgpPeer. </summary>
        public BfdEnabled? BfdEnabled { get; set; }
        /// <summary> The indicator to enable multi-hop peering support. </summary>
        public BgpMultiHop? BgpMultiHop { get; set; }
        /// <summary> The requested BGP hold time value. This field uses ISO 8601 duration format, for example P1H. </summary>
        public string HoldTime { get; set; }
        /// <summary> The requested BGP keepalive time value. This field uses ISO 8601 duration format, for example P1H. </summary>
        public string KeepAliveTime { get; set; }
        /// <summary> The autonomous system number used for the local end of the BGP session. </summary>
        public long? MyAsn { get; set; }
        /// <summary> The name used to identify this BGP peer for association with a BGP advertisement. </summary>
        public string Name { get; set; }
        /// <summary> The authentication password for routers enforcing TCP MD5 authenticated sessions. </summary>
        public string Password { get; set; }
        /// <summary> The IPv4 or IPv6 address used to connect this BGP session. </summary>
        public string PeerAddress { get; set; }
        /// <summary> The autonomous system number expected from the remote end of the BGP session. </summary>
        public long PeerAsn { get; set; }
        /// <summary> The port used to connect this BGP session. </summary>
        public long? PeerPort { get; set; }
    }
}
