// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The indicator of whether the remote vendor management feature is enabled or disabled, or unsupported if it is an unsupported feature. </summary>
    public readonly partial struct RemoteVendorManagementStatus : IEquatable<RemoteVendorManagementStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RemoteVendorManagementStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RemoteVendorManagementStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";
        private const string UnsupportedValue = "Unsupported";

        /// <summary> Enabled. </summary>
        public static RemoteVendorManagementStatus Enabled { get; } = new RemoteVendorManagementStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static RemoteVendorManagementStatus Disabled { get; } = new RemoteVendorManagementStatus(DisabledValue);
        /// <summary> Unsupported. </summary>
        public static RemoteVendorManagementStatus Unsupported { get; } = new RemoteVendorManagementStatus(UnsupportedValue);
        /// <summary> Determines if two <see cref="RemoteVendorManagementStatus"/> values are the same. </summary>
        public static bool operator ==(RemoteVendorManagementStatus left, RemoteVendorManagementStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RemoteVendorManagementStatus"/> values are not the same. </summary>
        public static bool operator !=(RemoteVendorManagementStatus left, RemoteVendorManagementStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RemoteVendorManagementStatus"/>. </summary>
        public static implicit operator RemoteVendorManagementStatus(string value) => new RemoteVendorManagementStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RemoteVendorManagementStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RemoteVendorManagementStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
