// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The indicator of whether the storage appliance supports remote vendor management. </summary>
    public readonly partial struct RemoteVendorManagementFeature : IEquatable<RemoteVendorManagementFeature>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RemoteVendorManagementFeature"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RemoteVendorManagementFeature(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SupportedValue = "Supported";
        private const string UnsupportedValue = "Unsupported";

        /// <summary> Supported. </summary>
        public static RemoteVendorManagementFeature Supported { get; } = new RemoteVendorManagementFeature(SupportedValue);
        /// <summary> Unsupported. </summary>
        public static RemoteVendorManagementFeature Unsupported { get; } = new RemoteVendorManagementFeature(UnsupportedValue);
        /// <summary> Determines if two <see cref="RemoteVendorManagementFeature"/> values are the same. </summary>
        public static bool operator ==(RemoteVendorManagementFeature left, RemoteVendorManagementFeature right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RemoteVendorManagementFeature"/> values are not the same. </summary>
        public static bool operator !=(RemoteVendorManagementFeature left, RemoteVendorManagementFeature right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RemoteVendorManagementFeature"/>. </summary>
        public static implicit operator RemoteVendorManagementFeature(string value) => new RemoteVendorManagementFeature(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RemoteVendorManagementFeature other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RemoteVendorManagementFeature other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
