// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The provisioning state of the rack resource. </summary>
    public readonly partial struct RackProvisioningState : IEquatable<RackProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RackProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RackProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string AcceptedValue = "Accepted";

        /// <summary> Succeeded. </summary>
        public static RackProvisioningState Succeeded { get; } = new RackProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static RackProvisioningState Failed { get; } = new RackProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static RackProvisioningState Canceled { get; } = new RackProvisioningState(CanceledValue);
        /// <summary> Provisioning. </summary>
        public static RackProvisioningState Provisioning { get; } = new RackProvisioningState(ProvisioningValue);
        /// <summary> Accepted. </summary>
        public static RackProvisioningState Accepted { get; } = new RackProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="RackProvisioningState"/> values are the same. </summary>
        public static bool operator ==(RackProvisioningState left, RackProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RackProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(RackProvisioningState left, RackProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RackProvisioningState"/>. </summary>
        public static implicit operator RackProvisioningState(string value) => new RackProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RackProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RackProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
