// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The strategy for deleting the OS disk. </summary>
    public readonly partial struct OSDiskDeleteOption : IEquatable<OSDiskDeleteOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OSDiskDeleteOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OSDiskDeleteOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "Delete";

        /// <summary> Delete. </summary>
        public static OSDiskDeleteOption Delete { get; } = new OSDiskDeleteOption(DeleteValue);
        /// <summary> Determines if two <see cref="OSDiskDeleteOption"/> values are the same. </summary>
        public static bool operator ==(OSDiskDeleteOption left, OSDiskDeleteOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OSDiskDeleteOption"/> values are not the same. </summary>
        public static bool operator !=(OSDiskDeleteOption left, OSDiskDeleteOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OSDiskDeleteOption"/>. </summary>
        public static implicit operator OSDiskDeleteOption(string value) => new OSDiskDeleteOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OSDiskDeleteOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OSDiskDeleteOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
