// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The strategy for creating the OS disk. </summary>
    public readonly partial struct OSDiskCreateOption : IEquatable<OSDiskCreateOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OSDiskCreateOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OSDiskCreateOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EphemeralValue = "Ephemeral";

        /// <summary> Ephemeral. </summary>
        public static OSDiskCreateOption Ephemeral { get; } = new OSDiskCreateOption(EphemeralValue);
        /// <summary> Determines if two <see cref="OSDiskCreateOption"/> values are the same. </summary>
        public static bool operator ==(OSDiskCreateOption left, OSDiskCreateOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OSDiskCreateOption"/> values are not the same. </summary>
        public static bool operator !=(OSDiskCreateOption left, OSDiskCreateOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OSDiskCreateOption"/>. </summary>
        public static implicit operator OSDiskCreateOption(string value) => new OSDiskCreateOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OSDiskCreateOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OSDiskCreateOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
