// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> StorageProfile represents information about a disk. </summary>
    public partial class NetworkCloudStorageProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkCloudStorageProfile"/>. </summary>
        /// <param name="osDisk"> The disk to use with this virtual machine. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="osDisk"/> is null. </exception>
        public NetworkCloudStorageProfile(NetworkCloudOSDisk osDisk)
        {
            Argument.AssertNotNull(osDisk, nameof(osDisk));

            OSDisk = osDisk;
            VolumeAttachments = new ChangeTrackingList<ResourceIdentifier>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudStorageProfile"/>. </summary>
        /// <param name="osDisk"> The disk to use with this virtual machine. </param>
        /// <param name="volumeAttachments"> The resource IDs of volumes that are requested to be attached to the virtual machine. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkCloudStorageProfile(NetworkCloudOSDisk osDisk, IList<ResourceIdentifier> volumeAttachments, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OSDisk = osDisk;
            VolumeAttachments = volumeAttachments;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudStorageProfile"/> for deserialization. </summary>
        internal NetworkCloudStorageProfile()
        {
        }

        /// <summary> The disk to use with this virtual machine. </summary>
        public NetworkCloudOSDisk OSDisk { get; set; }
        /// <summary> The resource IDs of volumes that are requested to be attached to the virtual machine. </summary>
        public IList<ResourceIdentifier> VolumeAttachments { get; }
    }
}
