// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> SshPublicKey represents the public key used to authenticate with a resource through SSH. </summary>
    public partial class NetworkCloudSshPublicKey
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkCloudSshPublicKey"/>. </summary>
        /// <param name="keyData"> The SSH public key data. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="keyData"/> is null. </exception>
        public NetworkCloudSshPublicKey(string keyData)
        {
            Argument.AssertNotNull(keyData, nameof(keyData));

            KeyData = keyData;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudSshPublicKey"/>. </summary>
        /// <param name="keyData"> The SSH public key data. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkCloudSshPublicKey(string keyData, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyData = keyData;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudSshPublicKey"/> for deserialization. </summary>
        internal NetworkCloudSshPublicKey()
        {
        }

        /// <summary> The SSH public key data. </summary>
        public string KeyData { get; set; }
    }
}
