// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> NetworkInterface represents properties of the network interface. </summary>
    public partial class NetworkCloudNetworkInterface
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkCloudNetworkInterface"/>. </summary>
        internal NetworkCloudNetworkInterface()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudNetworkInterface"/>. </summary>
        /// <param name="address"> The partial address of Peripheral Component Interconnect (PCI). </param>
        /// <param name="deviceConnectionType"> The connection type of the device. </param>
        /// <param name="model"> The model name of the device. </param>
        /// <param name="physicalSlot"> The physical slot for this device. </param>
        /// <param name="portCount"> The number of ports on the device. </param>
        /// <param name="portSpeed"> The maximum amount of data in GB that the line card transmits through a port at any given second. </param>
        /// <param name="vendor"> The vendor name of the device. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkCloudNetworkInterface(string address, DeviceConnectionType? deviceConnectionType, string model, long? physicalSlot, long? portCount, long? portSpeed, string vendor, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Address = address;
            DeviceConnectionType = deviceConnectionType;
            Model = model;
            PhysicalSlot = physicalSlot;
            PortCount = portCount;
            PortSpeed = portSpeed;
            Vendor = vendor;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The partial address of Peripheral Component Interconnect (PCI). </summary>
        public string Address { get; }
        /// <summary> The connection type of the device. </summary>
        public DeviceConnectionType? DeviceConnectionType { get; }
        /// <summary> The model name of the device. </summary>
        public string Model { get; }
        /// <summary> The physical slot for this device. </summary>
        public long? PhysicalSlot { get; }
        /// <summary> The number of ports on the device. </summary>
        public long? PortCount { get; }
        /// <summary> The maximum amount of data in GB that the line card transmits through a port at any given second. </summary>
        public long? PortSpeed { get; }
        /// <summary> The vendor name of the device. </summary>
        public string Vendor { get; }
    }
}
