// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> AgentOptions are configurations that will be applied to each agent in an agent pool. </summary>
    public partial class NetworkCloudAgentConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkCloudAgentConfiguration"/>. </summary>
        /// <param name="hugepagesCount"> The number of hugepages to allocate. </param>
        public NetworkCloudAgentConfiguration(long hugepagesCount)
        {
            HugepagesCount = hugepagesCount;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudAgentConfiguration"/>. </summary>
        /// <param name="hugepagesCount"> The number of hugepages to allocate. </param>
        /// <param name="hugepagesSize"> The size of the hugepages to allocate. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkCloudAgentConfiguration(long hugepagesCount, HugepagesSize? hugepagesSize, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            HugepagesCount = hugepagesCount;
            HugepagesSize = hugepagesSize;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudAgentConfiguration"/> for deserialization. </summary>
        internal NetworkCloudAgentConfiguration()
        {
        }

        /// <summary> The number of hugepages to allocate. </summary>
        public long HugepagesCount { get; set; }
        /// <summary> The size of the hugepages to allocate. </summary>
        public HugepagesSize? HugepagesSize { get; set; }
    }
}
