// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> AadConfiguration represents the Azure Active Directory Integration properties. </summary>
    internal partial class NetworkCloudAadConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkCloudAadConfiguration"/>. </summary>
        /// <param name="adminGroupObjectIds"> The list of Azure Active Directory group object IDs that will have an administrative role on the Kubernetes cluster. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="adminGroupObjectIds"/> is null. </exception>
        public NetworkCloudAadConfiguration(IEnumerable<string> adminGroupObjectIds)
        {
            Argument.AssertNotNull(adminGroupObjectIds, nameof(adminGroupObjectIds));

            AdminGroupObjectIds = adminGroupObjectIds.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudAadConfiguration"/>. </summary>
        /// <param name="adminGroupObjectIds"> The list of Azure Active Directory group object IDs that will have an administrative role on the Kubernetes cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkCloudAadConfiguration(IList<string> adminGroupObjectIds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AdminGroupObjectIds = adminGroupObjectIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NetworkCloudAadConfiguration"/> for deserialization. </summary>
        internal NetworkCloudAadConfiguration()
        {
        }

        /// <summary> The list of Azure Active Directory group object IDs that will have an administrative role on the Kubernetes cluster. </summary>
        public IList<string> AdminGroupObjectIds { get; }
    }
}
