// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The connection type of the rack SKU resource. </summary>
    public readonly partial struct MachineSkuDiskConnectionType : IEquatable<MachineSkuDiskConnectionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MachineSkuDiskConnectionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MachineSkuDiskConnectionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PcieValue = "PCIE";
        private const string SataValue = "SATA";
        private const string RaidValue = "RAID";
        private const string SASValue = "SAS";

        /// <summary> PCIE. </summary>
        public static MachineSkuDiskConnectionType Pcie { get; } = new MachineSkuDiskConnectionType(PcieValue);
        /// <summary> SATA. </summary>
        public static MachineSkuDiskConnectionType Sata { get; } = new MachineSkuDiskConnectionType(SataValue);
        /// <summary> RAID. </summary>
        public static MachineSkuDiskConnectionType Raid { get; } = new MachineSkuDiskConnectionType(RaidValue);
        /// <summary> SAS. </summary>
        public static MachineSkuDiskConnectionType SAS { get; } = new MachineSkuDiskConnectionType(SASValue);
        /// <summary> Determines if two <see cref="MachineSkuDiskConnectionType"/> values are the same. </summary>
        public static bool operator ==(MachineSkuDiskConnectionType left, MachineSkuDiskConnectionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MachineSkuDiskConnectionType"/> values are not the same. </summary>
        public static bool operator !=(MachineSkuDiskConnectionType left, MachineSkuDiskConnectionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MachineSkuDiskConnectionType"/>. </summary>
        public static implicit operator MachineSkuDiskConnectionType(string value) => new MachineSkuDiskConnectionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MachineSkuDiskConnectionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MachineSkuDiskConnectionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
