// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> Type Deprecated. Will be removed in an upcoming version. LldpNeighbor represents the details about the device connected to the NIC. </summary>
    public partial class LldpNeighbor
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LldpNeighbor"/>. </summary>
        internal LldpNeighbor()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LldpNeighbor"/>. </summary>
        /// <param name="portDescription"> The descriptive information about the port on the connected device. </param>
        /// <param name="portName"> The system-assigned name of the port on the connected device. </param>
        /// <param name="systemDescription"> The descriptive information about the connected device. </param>
        /// <param name="systemName"> The system-assigned name of the connected device. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LldpNeighbor(string portDescription, string portName, string systemDescription, string systemName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PortDescription = portDescription;
            PortName = portName;
            SystemDescription = systemDescription;
            SystemName = systemName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The descriptive information about the port on the connected device. </summary>
        public string PortDescription { get; }
        /// <summary> The system-assigned name of the port on the connected device. </summary>
        public string PortName { get; }
        /// <summary> The descriptive information about the connected device. </summary>
        public string SystemDescription { get; }
        /// <summary> The system-assigned name of the connected device. </summary>
        public string SystemName { get; }
    }
}
