// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The more detailed status of the L3 network. </summary>
    public readonly partial struct L3NetworkDetailedStatus : IEquatable<L3NetworkDetailedStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="L3NetworkDetailedStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public L3NetworkDetailedStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ErrorValue = "Error";
        private const string AvailableValue = "Available";
        private const string ProvisioningValue = "Provisioning";

        /// <summary> Error. </summary>
        public static L3NetworkDetailedStatus Error { get; } = new L3NetworkDetailedStatus(ErrorValue);
        /// <summary> Available. </summary>
        public static L3NetworkDetailedStatus Available { get; } = new L3NetworkDetailedStatus(AvailableValue);
        /// <summary> Provisioning. </summary>
        public static L3NetworkDetailedStatus Provisioning { get; } = new L3NetworkDetailedStatus(ProvisioningValue);
        /// <summary> Determines if two <see cref="L3NetworkDetailedStatus"/> values are the same. </summary>
        public static bool operator ==(L3NetworkDetailedStatus left, L3NetworkDetailedStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="L3NetworkDetailedStatus"/> values are not the same. </summary>
        public static bool operator !=(L3NetworkDetailedStatus left, L3NetworkDetailedStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="L3NetworkDetailedStatus"/>. </summary>
        public static implicit operator L3NetworkDetailedStatus(string value) => new L3NetworkDetailedStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is L3NetworkDetailedStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(L3NetworkDetailedStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
