// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The indication of whether this network will or will not perform IP address management and allocate IP addresses when attached. </summary>
    public readonly partial struct L3NetworkConfigurationIpamEnabled : IEquatable<L3NetworkConfigurationIpamEnabled>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="L3NetworkConfigurationIpamEnabled"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public L3NetworkConfigurationIpamEnabled(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static L3NetworkConfigurationIpamEnabled True { get; } = new L3NetworkConfigurationIpamEnabled(TrueValue);
        /// <summary> False. </summary>
        public static L3NetworkConfigurationIpamEnabled False { get; } = new L3NetworkConfigurationIpamEnabled(FalseValue);
        /// <summary> Determines if two <see cref="L3NetworkConfigurationIpamEnabled"/> values are the same. </summary>
        public static bool operator ==(L3NetworkConfigurationIpamEnabled left, L3NetworkConfigurationIpamEnabled right) => left.Equals(right);
        /// <summary> Determines if two <see cref="L3NetworkConfigurationIpamEnabled"/> values are not the same. </summary>
        public static bool operator !=(L3NetworkConfigurationIpamEnabled left, L3NetworkConfigurationIpamEnabled right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="L3NetworkConfigurationIpamEnabled"/>. </summary>
        public static implicit operator L3NetworkConfigurationIpamEnabled(string value) => new L3NetworkConfigurationIpamEnabled(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is L3NetworkConfigurationIpamEnabled other && Equals(other);
        /// <inheritdoc />
        public bool Equals(L3NetworkConfigurationIpamEnabled other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
