// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The provisioning state of the L2 network. </summary>
    public readonly partial struct L2NetworkProvisioningState : IEquatable<L2NetworkProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="L2NetworkProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public L2NetworkProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string AcceptedValue = "Accepted";

        /// <summary> Succeeded. </summary>
        public static L2NetworkProvisioningState Succeeded { get; } = new L2NetworkProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static L2NetworkProvisioningState Failed { get; } = new L2NetworkProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static L2NetworkProvisioningState Canceled { get; } = new L2NetworkProvisioningState(CanceledValue);
        /// <summary> Provisioning. </summary>
        public static L2NetworkProvisioningState Provisioning { get; } = new L2NetworkProvisioningState(ProvisioningValue);
        /// <summary> Accepted. </summary>
        public static L2NetworkProvisioningState Accepted { get; } = new L2NetworkProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="L2NetworkProvisioningState"/> values are the same. </summary>
        public static bool operator ==(L2NetworkProvisioningState left, L2NetworkProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="L2NetworkProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(L2NetworkProvisioningState left, L2NetworkProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="L2NetworkProvisioningState"/>. </summary>
        public static implicit operator L2NetworkProvisioningState(string value) => new L2NetworkProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is L2NetworkProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(L2NetworkProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
