// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The indicator of how this network will be utilized by the Kubernetes cluster. </summary>
    public readonly partial struct KubernetesPluginType : IEquatable<KubernetesPluginType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KubernetesPluginType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KubernetesPluginType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DpdkValue = "DPDK";
        private const string SriovValue = "SRIOV";
        private const string OSDeviceValue = "OSDevice";
        private const string MacvlanValue = "MACVLAN";
        private const string IpvlanValue = "IPVLAN";

        /// <summary> DPDK. </summary>
        public static KubernetesPluginType Dpdk { get; } = new KubernetesPluginType(DpdkValue);
        /// <summary> SRIOV. </summary>
        public static KubernetesPluginType Sriov { get; } = new KubernetesPluginType(SriovValue);
        /// <summary> OSDevice. </summary>
        public static KubernetesPluginType OSDevice { get; } = new KubernetesPluginType(OSDeviceValue);
        /// <summary> MACVLAN. </summary>
        public static KubernetesPluginType Macvlan { get; } = new KubernetesPluginType(MacvlanValue);
        /// <summary> IPVLAN. </summary>
        public static KubernetesPluginType Ipvlan { get; } = new KubernetesPluginType(IpvlanValue);
        /// <summary> Determines if two <see cref="KubernetesPluginType"/> values are the same. </summary>
        public static bool operator ==(KubernetesPluginType left, KubernetesPluginType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KubernetesPluginType"/> values are not the same. </summary>
        public static bool operator !=(KubernetesPluginType left, KubernetesPluginType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KubernetesPluginType"/>. </summary>
        public static implicit operator KubernetesPluginType(string value) => new KubernetesPluginType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KubernetesPluginType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KubernetesPluginType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
