// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The role of this node in the cluster. </summary>
    public readonly partial struct KubernetesNodeRole : IEquatable<KubernetesNodeRole>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KubernetesNodeRole"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KubernetesNodeRole(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ControlPlaneValue = "ControlPlane";
        private const string WorkerValue = "Worker";

        /// <summary> ControlPlane. </summary>
        public static KubernetesNodeRole ControlPlane { get; } = new KubernetesNodeRole(ControlPlaneValue);
        /// <summary> Worker. </summary>
        public static KubernetesNodeRole Worker { get; } = new KubernetesNodeRole(WorkerValue);
        /// <summary> Determines if two <see cref="KubernetesNodeRole"/> values are the same. </summary>
        public static bool operator ==(KubernetesNodeRole left, KubernetesNodeRole right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KubernetesNodeRole"/> values are not the same. </summary>
        public static bool operator !=(KubernetesNodeRole left, KubernetesNodeRole right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KubernetesNodeRole"/>. </summary>
        public static implicit operator KubernetesNodeRole(string value) => new KubernetesNodeRole(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KubernetesNodeRole other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KubernetesNodeRole other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
