// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The power state of this node. </summary>
    public readonly partial struct KubernetesNodePowerState : IEquatable<KubernetesNodePowerState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KubernetesNodePowerState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KubernetesNodePowerState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnValue = "On";
        private const string OffValue = "Off";
        private const string UnknownValue = "Unknown";

        /// <summary> On. </summary>
        public static KubernetesNodePowerState On { get; } = new KubernetesNodePowerState(OnValue);
        /// <summary> Off. </summary>
        public static KubernetesNodePowerState Off { get; } = new KubernetesNodePowerState(OffValue);
        /// <summary> Unknown. </summary>
        public static KubernetesNodePowerState Unknown { get; } = new KubernetesNodePowerState(UnknownValue);
        /// <summary> Determines if two <see cref="KubernetesNodePowerState"/> values are the same. </summary>
        public static bool operator ==(KubernetesNodePowerState left, KubernetesNodePowerState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KubernetesNodePowerState"/> values are not the same. </summary>
        public static bool operator !=(KubernetesNodePowerState left, KubernetesNodePowerState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KubernetesNodePowerState"/>. </summary>
        public static implicit operator KubernetesNodePowerState(string value) => new KubernetesNodePowerState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KubernetesNodePowerState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KubernetesNodePowerState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
