// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The detailed state of this node. </summary>
    public readonly partial struct KubernetesClusterNodeDetailedStatus : IEquatable<KubernetesClusterNodeDetailedStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KubernetesClusterNodeDetailedStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KubernetesClusterNodeDetailedStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AvailableValue = "Available";
        private const string ErrorValue = "Error";
        private const string ProvisioningValue = "Provisioning";
        private const string RunningValue = "Running";
        private const string SchedulingValue = "Scheduling";
        private const string StoppedValue = "Stopped";
        private const string TerminatingValue = "Terminating";
        private const string UnknownValue = "Unknown";

        /// <summary> Available. </summary>
        public static KubernetesClusterNodeDetailedStatus Available { get; } = new KubernetesClusterNodeDetailedStatus(AvailableValue);
        /// <summary> Error. </summary>
        public static KubernetesClusterNodeDetailedStatus Error { get; } = new KubernetesClusterNodeDetailedStatus(ErrorValue);
        /// <summary> Provisioning. </summary>
        public static KubernetesClusterNodeDetailedStatus Provisioning { get; } = new KubernetesClusterNodeDetailedStatus(ProvisioningValue);
        /// <summary> Running. </summary>
        public static KubernetesClusterNodeDetailedStatus Running { get; } = new KubernetesClusterNodeDetailedStatus(RunningValue);
        /// <summary> Scheduling. </summary>
        public static KubernetesClusterNodeDetailedStatus Scheduling { get; } = new KubernetesClusterNodeDetailedStatus(SchedulingValue);
        /// <summary> Stopped. </summary>
        public static KubernetesClusterNodeDetailedStatus Stopped { get; } = new KubernetesClusterNodeDetailedStatus(StoppedValue);
        /// <summary> Terminating. </summary>
        public static KubernetesClusterNodeDetailedStatus Terminating { get; } = new KubernetesClusterNodeDetailedStatus(TerminatingValue);
        /// <summary> Unknown. </summary>
        public static KubernetesClusterNodeDetailedStatus Unknown { get; } = new KubernetesClusterNodeDetailedStatus(UnknownValue);
        /// <summary> Determines if two <see cref="KubernetesClusterNodeDetailedStatus"/> values are the same. </summary>
        public static bool operator ==(KubernetesClusterNodeDetailedStatus left, KubernetesClusterNodeDetailedStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KubernetesClusterNodeDetailedStatus"/> values are not the same. </summary>
        public static bool operator !=(KubernetesClusterNodeDetailedStatus left, KubernetesClusterNodeDetailedStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KubernetesClusterNodeDetailedStatus"/>. </summary>
        public static implicit operator KubernetesClusterNodeDetailedStatus(string value) => new KubernetesClusterNodeDetailedStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KubernetesClusterNodeDetailedStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KubernetesClusterNodeDetailedStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
