// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> KeySetUserStatus represents the status of the key set user. </summary>
    public partial class KeySetUserStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KeySetUserStatus"/>. </summary>
        internal KeySetUserStatus()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KeySetUserStatus"/>. </summary>
        /// <param name="azureUserName"> The user name that will be used for access. </param>
        /// <param name="status"> The indicator of whether the user is currently deployed for access. </param>
        /// <param name="statusMessage"> The additional information describing the current status of this user, if any available. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KeySetUserStatus(string azureUserName, BareMetalMachineKeySetUserSetupStatus? status, string statusMessage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AzureUserName = azureUserName;
            Status = status;
            StatusMessage = statusMessage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The user name that will be used for access. </summary>
        public string AzureUserName { get; }
        /// <summary> The indicator of whether the user is currently deployed for access. </summary>
        public BareMetalMachineKeySetUserSetupStatus? Status { get; }
        /// <summary> The additional information describing the current status of this user, if any available. </summary>
        public string StatusMessage { get; }
    }
}
