// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS. </summary>
    public readonly partial struct HybridAksPluginType : IEquatable<HybridAksPluginType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridAksPluginType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridAksPluginType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DpdkValue = "DPDK";
        private const string SriovValue = "SRIOV";
        private const string OSDeviceValue = "OSDevice";

        /// <summary> DPDK. </summary>
        public static HybridAksPluginType Dpdk { get; } = new HybridAksPluginType(DpdkValue);
        /// <summary> SRIOV. </summary>
        public static HybridAksPluginType Sriov { get; } = new HybridAksPluginType(SriovValue);
        /// <summary> OSDevice. </summary>
        public static HybridAksPluginType OSDevice { get; } = new HybridAksPluginType(OSDeviceValue);
        /// <summary> Determines if two <see cref="HybridAksPluginType"/> values are the same. </summary>
        public static bool operator ==(HybridAksPluginType left, HybridAksPluginType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridAksPluginType"/> values are not the same. </summary>
        public static bool operator !=(HybridAksPluginType left, HybridAksPluginType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridAksPluginType"/>. </summary>
        public static implicit operator HybridAksPluginType(string value) => new HybridAksPluginType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridAksPluginType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridAksPluginType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
