// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The size of the hugepages to allocate. </summary>
    public readonly partial struct HugepagesSize : IEquatable<HugepagesSize>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HugepagesSize"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HugepagesSize(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TwoMValue = "2M";
        private const string OneGValue = "1G";

        /// <summary> 2M. </summary>
        public static HugepagesSize TwoM { get; } = new HugepagesSize(TwoMValue);
        /// <summary> 1G. </summary>
        public static HugepagesSize OneG { get; } = new HugepagesSize(OneGValue);
        /// <summary> Determines if two <see cref="HugepagesSize"/> values are the same. </summary>
        public static bool operator ==(HugepagesSize left, HugepagesSize right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HugepagesSize"/> values are not the same. </summary>
        public static bool operator !=(HugepagesSize left, HugepagesSize right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HugepagesSize"/>. </summary>
        public static implicit operator HugepagesSize(string value) => new HugepagesSize(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HugepagesSize other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HugepagesSize other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
