// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The status representing the state of this feature. </summary>
    public readonly partial struct FeatureDetailedStatus : IEquatable<FeatureDetailedStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FeatureDetailedStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FeatureDetailedStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RunningValue = "Running";
        private const string FailedValue = "Failed";
        private const string UnknownValue = "Unknown";

        /// <summary> Running. </summary>
        public static FeatureDetailedStatus Running { get; } = new FeatureDetailedStatus(RunningValue);
        /// <summary> Failed. </summary>
        public static FeatureDetailedStatus Failed { get; } = new FeatureDetailedStatus(FailedValue);
        /// <summary> Unknown. </summary>
        public static FeatureDetailedStatus Unknown { get; } = new FeatureDetailedStatus(UnknownValue);
        /// <summary> Determines if two <see cref="FeatureDetailedStatus"/> values are the same. </summary>
        public static bool operator ==(FeatureDetailedStatus left, FeatureDetailedStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FeatureDetailedStatus"/> values are not the same. </summary>
        public static bool operator !=(FeatureDetailedStatus left, FeatureDetailedStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FeatureDetailedStatus"/>. </summary>
        public static implicit operator FeatureDetailedStatus(string value) => new FeatureDetailedStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FeatureDetailedStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FeatureDetailedStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
