// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The disk type of rack SKU resource. </summary>
    public readonly partial struct DiskType : IEquatable<DiskType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DiskType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DiskType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HDDValue = "HDD";
        private const string SSDValue = "SSD";

        /// <summary> HDD. </summary>
        public static DiskType HDD { get; } = new DiskType(HDDValue);
        /// <summary> SSD. </summary>
        public static DiskType SSD { get; } = new DiskType(SSDValue);
        /// <summary> Determines if two <see cref="DiskType"/> values are the same. </summary>
        public static bool operator ==(DiskType left, DiskType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DiskType"/> values are not the same. </summary>
        public static bool operator !=(DiskType left, DiskType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DiskType"/>. </summary>
        public static implicit operator DiskType(string value) => new DiskType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DiskType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DiskType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
