// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The connection type of the device. </summary>
    public readonly partial struct DeviceConnectionType : IEquatable<DeviceConnectionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceConnectionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceConnectionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PCIValue = "PCI";

        /// <summary> PCI. </summary>
        public static DeviceConnectionType PCI { get; } = new DeviceConnectionType(PCIValue);
        /// <summary> Determines if two <see cref="DeviceConnectionType"/> values are the same. </summary>
        public static bool operator ==(DeviceConnectionType left, DeviceConnectionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceConnectionType"/> values are not the same. </summary>
        public static bool operator !=(DeviceConnectionType left, DeviceConnectionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceConnectionType"/>. </summary>
        public static implicit operator DeviceConnectionType(string value) => new DeviceConnectionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceConnectionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceConnectionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
