// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary>
    /// The indicator of whether this is the default gateway.
    /// Only one of the attached networks (including the CloudServicesNetwork attachment) for a single machine may be specified as True.
    /// </summary>
    public readonly partial struct DefaultGateway : IEquatable<DefaultGateway>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DefaultGateway"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DefaultGateway(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static DefaultGateway True { get; } = new DefaultGateway(TrueValue);
        /// <summary> False. </summary>
        public static DefaultGateway False { get; } = new DefaultGateway(FalseValue);
        /// <summary> Determines if two <see cref="DefaultGateway"/> values are the same. </summary>
        public static bool operator ==(DefaultGateway left, DefaultGateway right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DefaultGateway"/> values are not the same. </summary>
        public static bool operator !=(DefaultGateway left, DefaultGateway right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DefaultGateway"/>. </summary>
        public static implicit operator DefaultGateway(string value) => new DefaultGateway(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DefaultGateway other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DefaultGateway other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
