// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.NetworkCloud.Models
{
    /// <summary> The provisioning state of the virtual machine console. </summary>
    public readonly partial struct ConsoleProvisioningState : IEquatable<ConsoleProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConsoleProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConsoleProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string AcceptedValue = "Accepted";

        /// <summary> Succeeded. </summary>
        public static ConsoleProvisioningState Succeeded { get; } = new ConsoleProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static ConsoleProvisioningState Failed { get; } = new ConsoleProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static ConsoleProvisioningState Canceled { get; } = new ConsoleProvisioningState(CanceledValue);
        /// <summary> Provisioning. </summary>
        public static ConsoleProvisioningState Provisioning { get; } = new ConsoleProvisioningState(ProvisioningValue);
        /// <summary> Accepted. </summary>
        public static ConsoleProvisioningState Accepted { get; } = new ConsoleProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="ConsoleProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ConsoleProvisioningState left, ConsoleProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConsoleProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ConsoleProvisioningState left, ConsoleProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConsoleProvisioningState"/>. </summary>
        public static implicit operator ConsoleProvisioningState(string value) => new ConsoleProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConsoleProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConsoleProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
